﻿#include  "StdAfx.h"
#include  <szString.hpp>
#include  <szRuntimeException.hpp>
#include  <buffers.hpp>

#include  <cstdarg>
#include  <strsafe.h>
#include  <boost/smart_ptr.hpp>

SZ_NS_BEG(szpp)

SZ_SPEC
std::string WideStringToNarrowString(const std::wstring &src)
{
  if (!src.empty())
  {
    const int size = WideCharToMultiByte(CP_ACP, 0, src.c_str(), static_cast<int>(src.size()), 0, 0, 0, 0);
    boost::scoped_array<char> buf(new char [size]);
    if (0 == WideCharToMultiByte(CP_ACP, 0, src.c_str(), static_cast<int>(src.size()), buf.get(), size, 0, 0))
      BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot convert string format")) << last_error_info(GetLastError()));
    return std::string(buf.get(), size);
  }
  return std::string();
}

SZ_SPEC
std::wstring NarrowStringToWideString(const std::string & src)
{
  if (!src.empty())
  {
    const int size = MultiByteToWideChar(CP_ACP, 0, src.c_str(), static_cast<int>(src.size()), 0, 0);
    boost::scoped_array<wchar_t> buf(new wchar_t [size]);
    if (0 == MultiByteToWideChar(CP_ACP, 0, src.c_str(), static_cast<int>(src.size()), buf.get(), size))
      BOOST_THROW_EXCEPTION(RuntimeException(SZT("Cannot convert string format")) << last_error_info(GetLastError()));
    return std::wstring(buf.get(), size);
  }
  return std::wstring();
}

SZ_SPEC
szstring Format(const szchar *fmt, ...)
{
  sbuf<szchar, 1024> buffer;

  va_list args;
  va_start(args, fmt);

  StringCchVPrintf(buffer, buffer.size(), fmt, args);

  va_end(args);

  return szstring(buffer);
}

SZ_NS_END(szpp)
